<?php

  namespace App\Exports;

  use App\Models\Payment;
  use Maatwebsite\Excel\Concerns\FromCollection;
  use Maatwebsite\Excel\Concerns\WithHeadings;

  class PaymentExport implements FromCollection, WithHeadings
  {
      protected $payments;

      public function __construct($payments)
      {
          $this->payments = $payments;
      }

      public function collection()
      {
          return $this->payments->map(function ($payment) {
              return [
                  'Payment ID' => $payment->Payment_id,
                  'User ID' => $payment->User_id,
                  'Amount' => $payment->Amount,
                  'Currency' => $payment->Currency,
                  'Status' => $payment->Payment_status,
                  'Gateway' => $payment->Payment_gateway,
                  'Transaction ID' => $payment->Transaction_id,
                  'Created At' => $payment->Created_at,
                  'Transaction Count' => $payment->transactions->count(),
                  'Refund Amount' => $payment->refunds->sum('Amount'),
              ];
          });
      }

      public function headings(): array
      {
          return [
              'Payment ID',
              'User ID',
              'Amount',
              'Currency',
              'Status',
              'Gateway',
              'Transaction ID',
              'Created At',
              'Transaction Count',
              'Refund Amount',
          ];
      }
  }
